import numpy as np

KPC_TO_M = 3.085677581491367e19

def compute_g(R_kpc, V_kms):
    Rm = np.asarray(R_kpc)*KPC_TO_M
    Vm = np.asarray(V_kms)*1000.0
    return (Vm**2)/np.maximum(Rm,1e-12)

def build_vbar(Vgas=None, Vdisk=None, Vbulge=None):
    terms=[]
    if Vgas is not None: terms.append(np.asarray(Vgas,float)**2)
    if Vdisk is not None: terms.append(np.asarray(Vdisk,float)**2)
    if Vbulge is not None: terms.append(np.asarray(Vbulge,float)**2)
    if not terms: return None
    return np.sqrt(np.sum(terms,axis=0))

def select_outer_window(R_kpc, Vobs_kms, dvdr_max, min_points, min_radius_kpc, min_span_kpc):
    R = np.asarray(R_kpc); V=np.asarray(Vobs_kms)
    dV = np.gradient(V, R)
    mask = (np.abs(dV)<=dvdr_max)&(R>=min_radius_kpc)
    best=(None,None,0.0); i=0
    while i<len(mask):
        if mask[i]:
            j=i
            while j<len(mask) and mask[j]: j+=1
            if (j-1)-i+1 >= min_points and (R[j-1]-R[i])>=min_span_kpc:
                span=R[j-1]-R[i]
                if span>best[2]: best=(i,j-1,span)
            i=j
        else: i+=1
    if best[0] is None: return 0,0,False
    return best[0],best[1],True

def compute_gstar_AR(alphaP, lambdaG, c_ms, UGM_phys_m, R_obs_m, R_G_kpc):
    Rm = R_G_kpc*KPC_TO_M
    chi = (Rm**2)/(UGM_phys_m*R_obs_m)
    return (alphaP*lambdaG*chi*(c_ms**2))/max(Rm,1e-12)

def compute_gstar_S(S_s2, R_G_kpc):
    Rm = R_G_kpc*KPC_TO_M
    return S_s2 * Rm
